/*
 * Author Ben Ranck
 * Evaluation Tree
 */

#include "evalTree.h"
#include <stdio.h>

SymbolTable * symTab;
/* These global vars used to control loops and so forth*/
	int breaknode = 0;
	int continuenode = 0;

int
evalTree(NODE * root, SymbolTable * sym) {
    	symTab = sym; 
        return eval(root);
}

/*
 * Runs recursively down the tree and evaluates depending on node type
 * evaluations which require a single line are within the function else they
 * are passed off to specific evaluation functions
 */

int
eval(NODE * node) {

	int switchInt = node->sNodeType;
    	int res = NULL;

    	switch(switchInt) {
    	case(NODE_ASSIGN) :
        	/* Assignment will have a left child type variable so we can go straigh to it's value */
        	res = symTab->entries[node->NodeLeft->sTableIndex].value = eval(node->NodeRight);
        	break;
    	case(NODE_BREAK) :
            breaknode = !breaknode;
            break;
    	case(NODE_PROGRAM) :
            res = evalProgram(node);
            break;
        case(NODE_CONTINUE) :
            continuenode = !continuenode;
            /* By using '!' operator can take care of nested	cases */
            break;
        case(NODE_EQ_OP) :
            res = ( eval(node->NodeLeft) == eval(node->NodeRight) );
            break;
        case(NODE_GT_OP) :
            res = ( eval(node->NodeLeft) > eval(node->NodeRight) );
            break;
        case(NODE_VARIABLE) :
            res = (symTab->entries[node->sTableIndex].value);
            break;
        case(NODE_DECLARATION) :
            /* If right tree is not NULL then declarition is also initialization */
            if(node->NodeRight != NULL)
                symTab->entries[node->NodeLeft->sTableIndex].value = eval(node->NodeRight);
            break;
        case(NODE_NUMBER) :
            res  = node->vari.sValue;
            break;
        case(NODE_LT_OP) :
            res = ( eval(node->NodeLeft) < eval(node->NodeRight) );
            break;
        case(NODE_WHILE) :
            res = evalWhile(node);
            break;
        case(NODE_SUB_OP) :
            res = ( eval(node->NodeLeft) - eval(node->NodeRight) );
            break;
        case(NODE_NEG_OP) :
            res = -(eval(node->NodeLeft));
            break;
        case(NODE_NOT_OP) :
            res = !(eval(node->NodeLeft));
            break;
        case(NODE_IF) :
            res = evalIf(node);
            break;
        case(NODE_OR_OP) :
            res = ( eval(node->NodeLeft) || eval(node->NodeRight) );
            break;
        case(NODE_AND_OP) :
            res = ( eval(node->NodeLeft) && eval(node->NodeRight) );
            break;
        case(NODE_MOD_OP) :
            res = ( eval(node->NodeLeft) % eval(node->NodeRight) );
            break;
        case(NODE_ADD_OP) :
            res = ( eval(node->NodeLeft) + eval(node->NodeRight) );
            break;
        case(NODE_MUL_OP) :
            res = ( eval(node->NodeLeft) * eval(node->NodeRight) );
            break;
	case(NODE_DIV_OP) :
            res = ( eval(node->NodeLeft) / eval(node->NodeRight) );
            break;
        case(NODE_RETURN) :
            res = eval(node->NodeLeft);
            break;
        case(NODE_IF_ELSE) :
            res = evalIfElse(node);
            break;
        case(NODE_ELSE) :
            puts("This node should never be evaluated here, always in the evalIfElse()");
            break;
        case(NODE_BLOCK) :
            res = evalBlock(node);
            break;
        default :
            printf("Unknown node type: %i\n", switchInt);
        

        }

        return res;
}

 /* evaluates a list  of declaration nodes on the left and a statement node on the right */
   
int
evalProgram(NODE * node) {
    int res = NULL;
    NODE* currNode;

    for(currNode = node->NodeLeft; currNode != NULL; currNode = currNode->NodeNext)
        eval(currNode);

    res = eval(node->NodeRight);
    return res;

}

 /* evaluates a list of declaration nodes on the left and statement nodes right */
   
int
evalBlock(NODE * node) {
    int res = NULL;
    NODE* currNode;

    for(currNode = node->NodeLeft; currNode != NULL; currNode = currNode->NodeNext)
        eval(currNode);
    for(currNode = node->NodeRight; currNode != NULL; currNode = currNode->NodeNext)
        res = eval(currNode);

    return res;
}

/* evaluates noderight while nodeleft is true */
 
int
evalWhile(NODE * node) {
    int res = NULL;

    while(eval(node->NodeLeft) ) {
        res = eval(node->NodeRight);
		if(breaknode){
			breaknode = !breaknode;
			break;
		}
		if(continuenode) {
			continuenode = !continuenode;
			continue;
		}
	}
    return res;
}

/* 
 * Single if statement, ie no else statement
 * nodeleft is condition noderight is statement to execute
 */

int
evalIf(NODE * node){
    int res = NULL;
    
    if( eval(node->NodeLeft) )
        res = eval(node->NodeRight);

    return res;
}

/*
 * takes an IF_ELSE node which has a nodeleft which is the condition and
 * and node right which is an ELSE node, if nodeleft is true it
 * evaluates the leftchild of it's noderight, otherwise it evaluates the
 * right child of it's noderight, ie ELSE node contains the if's statement
 * as well as it's statement
 */

int
evalIfElse(NODE * node) {
    	int res = NULL;

        if(eval(node->NodeLeft) )
            res = eval(node->NodeRight->NodeLeft);
        else
            res = eval(node->NodeRight->NodeRight);

        return res;
}


