#ifndef _NAME_ANALYSER_H
#define _NAME_ANALYSER_H

#define DEFAULT_ST_SIZE 10

/* An entry in the symbol table. In COMP3100 the entry can only
 represent an integer. */
typedef struct STEntry {
    int value;
    int isParam;
} STEntry;

typedef struct SymbolTable {
    STEntry * entries;
    int numEntries;
    int size;
} SymbolTable;

typedef struct Identifier {
  struct Identifier * next;
  char * name;
  int index;
} Identifier;

typedef struct EnvNode {
  struct EnvNode * firstChild;
  struct EnvNode * lastChild;
  Identifier * firstIdent;
  Identifier * lastIdent;
  struct EnvNode * parent;
  struct EnvNode * nextSibling;
} EnvNode;

/*typedef struct _node NODE;*/

void initEnvNode(EnvNode * node);
void addEnvChild(EnvNode * parent);
void addEnvIdent(EnvNode * node, char * name, SymbolTable * symTab);
void deleteEnvNode(EnvNode * node);
int getIdentIndex(EnvNode * node, char * name);

void deleteIdent(Identifier * ident);

void initSymTab(SymbolTable * symTab);
int addSymTabEntry(SymbolTable * symTab); /*returns the index of the new entry*/
void deleteSymTab(SymbolTable * symTab);

int analyseTree(NODE * root, EnvNode * rootEnv, SymbolTable * symTab);

#endif
