#ifndef _NODE_H
#define _NODE_H

#define TYPE_INTEGER		0
#define NODE_PROGRAM         	1
#define NODE_STATEMENT       	2 
#define NODE_FUNCTION        	3
#define NODE_EXPRESSION      	4
#define NODE_PREINCREMENT    	5
#define NODE_PREDECREMENT    	6
#define NODE_POSTINCREMENT   	7
#define NODE_POSTDECREMENT   	8
#define NODE_NUMBER          	9
#define NODE_STRING         	10
#define NODE_VARIABLE       	11
#define NODE_ELSE           	12
#define NODE_FOR            	13
#define NODE_IF             	14
#define NODE_RETURN         	15
#define NODE_WHILE          	16
#define NODE_INT            	17
#define NODE_VOID           	18
#define NODE_EXP_OP         	19
#define NODE_MUL_OP         	20
#define NODE_MOD_OP         	21
#define NODE_DIV_OP         	22
#define NODE_ADD_OP         	23
#define NODE_SUB_OP         	24
#define NODE_INC_OP         	25
#define NODE_DEC_OP         	26
#define NODE_NOT_OP         	27
#define NODE_AND_OP         	28
#define NODE_OR_OP          	29
#define NODE_LT_OP          	30
#define NODE_GT_OP          	31
#define NODE_LE_OP          	32 
#define NODE_GE_OP          	33
#define NODE_EQ_OP          	34
#define NODE_NE_OP          	35
#define NODE_ASSIGN         	36
#define NODE_BREAK          	37
#define NODE_DECLARATION    	38
#define NODE_QUESTION       	39
#define NODE_COLON          	40
#define NODE_CONTINUE       	41
#define NODE_MINUS_OP       	42
#define NODE_BLOCK          	43
#define NODE_NEG_OP         	44
#define NODE_IF_ELSE        	45

#define MAX_VAR_NAME_SIZE  	60

typedef struct _node
{
   	/* type of node */
   	int  sNodeType;

   	/* line number of node relative to code (for error reporting or debug) */
   	int  sLineNumber;

   	/* links to related nodes (depending on node type may not be used) */
   	struct _node *NodeLeft;
   	struct _node *NodeRight;
   
   	/* !NEW! link to the next node (used for nodes containing lists of expressions) */
   	struct _node *NodeNext;

   	/* type of variable (string, integers, chars etc)*/
   	int  sVariableType;

   	/* the index number of the variable in the symbol table*/
   	int sTableIndex;

   	/* the value of the token (as returned by LEXX tokenizer)*/
   	int  sTokenValue;
   
   	/* strings, integers and numbers*/
   	struct _vari {
       		int  sValue;
       		char szName[MAX_VAR_NAME_SIZE];
   	} vari;
            
} NODE;

/* Function to add nodes to the parse node list */
NODE *AddNumber(int sNumber);
NODE *AddVariable(char *pszName);
NODE *AddNode(NODE *left, int op, NODE *right);
NODE *AppendNode(NODE *nodeList, NODE *nodeNew);
void DeleteNode(NODE * node);

#endif
