/*
 * xalloc.c - general purpose memory allocations error checking wrappers
 * $Id: xalloc.c,v 1.6 2002/10/31 02:46:44 mathomas Exp $
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>
#include <errno.h>
#include <sys/types.h>
#include "xalloc.h"
#include "debug.h"

extern int errno;

/*
 * malloc(3) NULL-checking wrapper.
 */

void *
xmalloc(size_t size)
{
	void *ptr = NULL;

	if ((ptr = malloc(size)) == NULL)
		fatal("malloc(): %s\n", (void *) strerror(errno));

	memset(ptr, 0, size); /* malloc(3) neglects to zero out memory */
	
	return ptr;
}

/*
 * calloc(3) NULL-checking wrapper.
 */

void *
xcalloc(size_t nmemb, size_t size)
{
	void *ptr = NULL;

	if ((ptr = calloc(nmemb, size)) == NULL)
		fatal("calloc(): %s", (void *) strerror(errno));
	
	return ptr;
}


/*
 * realloc(3) NULL-checking wrapper.
 */

void *
xrealloc(void *pt, size_t size)
{
	void *ptr = NULL;
	
	if ((ptr = realloc(pt, size)) == NULL)
		fatal("realloc(): %s", (void *) strerror(errno));

	return ptr;
}

/*
 * free(3) NULL-checking wrapper
 *  - ANSI allows NULL, however it often causes arbitary problems elsewhere.
 */

void
xfree(void *ptr)
{
	assert(ptr != NULL);
	free(ptr);
}


/*
 * strdup(3) NULL-checking wrapper
 *
 */

void *
xstrdup(const char *str)
{ 
	char *copy; 
	copy = xmalloc(strlen(str) + 1); 
	strcpy(copy, str); 
	return copy; 
} 

