#ifndef XALLOC_H
#define XALLOC_H

/* general purpose memory allocation prototype definitions */

extern void *xmalloc(size_t size);
extern void *xcalloc(size_t nmemb, size_t size);
extern void *xrealloc(void *ptr, size_t size);
extern void xfree(void *ptr);
extern void *xstrdup(const char *);

/* macro definitions to handle type casting */

#define XMALLOC(type, num)		((type *) xmalloc(num * sizeof(type)))
#define XCALLOC(type, num)		((type *) xcalloc(num, sizeof(type)))
#define XREALLOC(type, ptr, num)	((type *) xrealloc(ptr, num * sizeof(type)))
#define XFREE(ptr)			do { xfree(ptr); ptr = NULL; } while (0);

/*
 * Example: char *ptr = XMALLOC(char, sizeof(buf)); 
 */

#endif /* XALLOC_H */

