#include "stdlib.h"
#include "stdio.h"
#include "string.h"


/* This is a modified version of strncpy where it grantees that the last byte of
 * the dest string is a null terminator. */
char* Strncpy (char* dest, const char* src, size_t n) {

    char* res;
    
    /* Perform the usual strncpy. */
    res = strncpy(dest, src, n);

    /* Now just make sure the string is null terminated, ie that the very last
     * byte it null terminated. */
    *(res + n - 1) = '\0';

    /* Now return the pointer to the dest string. */
    return res; 
}
